#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Truchet 84 (V2)Mod01.fsh    by    shadertoyjiang   
//https://www.shadertoy.com/view/43dfz4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


//      color = 0 or 1
#define COLOR    0

#define PI 3.1415926535
#define rot(a) mat2(cos(a), sin(a), -sin(a), cos(a))


float hash(vec2 p)//0048
{
        vec3 p3 = fract(p.xyx * 0.1031);
        p3 += dot(p3, p3 + 33.33);
        return fract((p3.x+p3.y)*p3.z);
}


void sort(int N,inout ivec2 arr[8])//0158 添
{
        bool hv =true;
        int i,j,k;
        ivec2 c;
        
        for(int j=0; j<N-1; j++)
        for(int i=j+1; i<N; i++)
        {
                if(arr[i].x<arr[j].x)
                {
                       c=arr[i];
                       arr[i]=arr[j];
                       arr[j]=c;
                }
        }
}        


#define J1(a, b) (((a)+N*2-(b))%(N*2)==1)

bool pass(int N, ivec2 arr[8])
{        
        
        int j,k,ia,ib,sum=0;
        ivec2 a, b,c;
        
        
        // 循环整理 1610
        //for(int i=0;i<N;i++)arr[i] %= N*2;
        
        // 排序
        
        /*for(int j =0;j<N-1; j++)
                for(int i=j+1;i<N;i++)
                {
                        if(arr[i].x < arr[j].x){c = arr[i]; arr[i]=arr[j];arr[j]=c;}
                }*/
        
        
        
  #if PASSMODE== 1       
        sum=0;
        for(int i=0; i<N; i++)
        {
                if(J1(arr[i].y,arr[i].x))sum++;
        }
        if(sum >3 ) return false; // 超过 x 个小包则失败
  #elif PASSMODE==2        
        for(int i=0; i<N; i++) // 连续两个小包失败
        { 
                a = arr[i];
                b = arr[(i+1)%N];
                if(J1(a.y,a.x) && J1(b.y,b.x)&& J1(b.x,a.y))return false;
        }
  #elif PASSMODE==3        
        sum = 0;
        for(int i=0; i<N; i++) // 连续两个小包失败
        { 
                a = arr[i];
                b = arr[(i+1)%N];
                if(J1(a.y, a.x )&& J1(b.y, b.x )&& J1(b.x, a.y ))sum++;
                i+=1;
        }
        if(sum >1 ) return false; // 超过 x 个2小包则失败
  #elif PASSMODE==4        
        for(int i=0; i<N; i++) // 连续两个小包失败
        { 
                a = arr[i];
                b = arr[(i+1)%N];
                c = arr[(i+2)%N];
                if(J1(a.y, a.x )&& J1(b.y, b.x )&& J1(c.y, c.x )&& J1(b.x, a.y )&& J1(c.x, b.x )return false;
        }
  #endif
        return true;
}

void llh(int N,inout ivec2 arr[8])//0158 添
{
        bool hv =true;
        int i,j,k;
        
        /*for(int j=0; j<N-1; j++)
        for(int i=j+1; i<N; i++)
        {
                ivec2 c;
                if(arr[i].x<arr[j].x)
                {
                       c=arr[i];
                       arr[i]=arr[j];
                       arr[j]=c;
                }
        }*/
        
        while(hv)
        {
                i = 0;
                for(; i<N-1; i++)
                {
                        
                        j=(i+2)%N;
                        k=(i+1)%N;
                        //if((arr[i].y-arr[i].x==1)&&(arr[j].y-arr[j].x==1)&&(arr[j].x-arr[i].y==1))
                        if(((arr[j].x-arr[i].x==4)&&( arr[k].x-arr[i].y==1  )))//||((arr[j].x+N-arr[i].x==4)&&((arr[k].x+N-arr[i].x==2)||(arr[k].x-arr[i].x==2))))
                        {
                                ivec2 a = ivec2(arr[i].x, arr[j].y),b = ivec2(arr[i].y, arr[j].x);
                                arr[i]=a; arr[j]=b;
                                break;
                        }
                }
                
                if(i==N-1)hv=false;
        }
                              
}

void setArr(vec2 i, int N, out ivec2 arr[8])
{
        int ind, n ; 
        float sum=0.; 
        
        for(int test=0;test<15;test++) 
        {
                arr[0].x=0; arr[0].y=1; n = 2;
                for(int j=1; j<N; j++) 
                { // 生成时都是从小到大排列，不用排序。
                        ind = int(float(n+1)*hash(i +sum+ vec2(N, j)*vec2(.123+sum, .456)))%(n+1);
                        for(int i=0; i<N;i++)
                        {
                                if(arr[i].x>=ind)arr[i].x+=2;//+arr[i].x)%N;
                                if(arr[i].y>=ind)arr[i].y+=2;//+arr[i].y)%N;
                        }
                        arr[j].x = ind;
                        arr[j].y = ind+1;
                        n += 2;
                }
                
                sort(N,arr);
                
                for(int i=0; i<N;i++)arr[i]%=N*2;
                
                
                sum += 123.124729;
                //if(N==8) 
                #if (PASSMODE==101)
                        llh(N, arr);
                        break;
                #elif (PASSMODE < 5 && PASSMODE>0)
                        if(pass(N, arr))break;
                #else
                        break;
                #endif
                //
                
                
        }
}




float dring(vec2 p, vec2 np, vec2 centp, vec2 q, vec2 nq, vec2 centq, vec2 u) // 0023
{// 求任意两条线段之间的“圆弧”
        vec2 c;
        float r0, r,d;
        vec3 ta,tb,tc;
        if( abs(nq.x *  np.y -  nq.y *  np.x)<.01) // dot(np, nq)
        {
                if( dot(np,nq)> 0.)
                { // 同一线段小的最小弧
                        c = (p+q)/2.;
                        r0 = length(p-c);
                        r = length(u-c);
                        d = r0-r;
                }else
                { // 正相对的两条线
                        //d = dline(p,q,u);
                        ta.xy = centp - p; tb.xy = normalize(q-p); tc.xy = u-p;
                        d = cross(tc, tb).z  * sign(cross(ta,tb).z);
                        
                }
        }else{ // 1340
                  // 两不平行边的连弧
                  // 已知 p, q, np, nq 求交点 c
                        float e =  p.x *  np.y -  np.x *  p.y,
                              f =  q.x *  nq.y -  nq.x *  q.y,
                              g =  nq.x *  np.y -  nq.y *  np.x;
                        c = ( nq * e -  np * f) / g;
                        //vec3 k = cross(vec3(p.x, q.x, nq.x), vec3(p.y, q.y, nq.y));
                        // c = (nq * k.x - np * k.y) / k.z;
                        r0 = length(p-c);
                        r = length(u-c);
                        d = (r0-r) * sign(dot(centp-p, c - p)); // 1345
        }
        //return dot(u,  normalize( cos(iTime+vec2(11, 0)))   );
        return d;
}

float dCur(vec2 f, vec2 i, int N)
{
        ivec2 arr[8];
        setArr(i, N, arr);
        // 0002
        float d = 1e8,fd,td=1e8,
              agl  ,  
              h = .5*tan(PI/float(N))/3.; // 8 边形的六分之一
        
        for(int i=0; i<N; i++)
        {
                ivec2 a = arr[i], b = a/2, nvg = (a - b * 2) * 2 -1; 
                vec2 agl = 2.*PI/float(N)*vec2(b);
                
                vec2 u = vec2(cos(agl.x), sin(agl.x)), np = vec2(-u.y, u.x);
                vec2 p = u * .5 + float(nvg.x) * np * h;
                vec2 v = vec2(cos(agl.y), sin(agl.y)), nq = vec2(-v.y, v.x);
                vec2 q = v * .5 + float(nvg.y) * nq * h;
                fd = dring(p, np, u*.5, q, nq, v*.5, f);
                if(d > abs(fd))d=abs(fd), td=fd;
        }
        return td;
}
#define O fragColor
#define u fragCoord

//void mainImage(out vec4 O, vec2 u){
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
        vec2 R = iResolution.xy;
        u = 3.*(u+u - R) / R.y + (29.+iTime)*vec2(.6,.3);
        u = rot(PI/4.) * u;
        
        vec2 f, a, i, n = normalize(vec2(1));
        
        i = round(u), f = u - i, a = abs(f);
        
        float dt = dot(a,n);
        float dframe  = 9999.; 
        
        if(dt < .5) dframe = min(.5-a.x, .5-a.y);
        dframe = min(dframe, abs(.5 - dt)); 
        
        float dc1 = dCur(f,i, 8);
        
        i = round(u-.5)+.5, f = u - i;//, a = abs(f);
        f = rot(PI/4.)*f;
        
        float agl = PI/8.; // TAU / 16.
        float h = tan(agl); // 八边形的边长
        
        float dc2 = dCur(f/h, i, 4)*h;//2345 为了少写代码用通用的过程
        O.x = exp(-60. * abs(.03-dframe));
        
        if(dt<.5){// octagon
                O.y = exp(-60.* abs(dc1));                
        }else{// square
                O.y = exp(-60.* abs(dc2));
                
        }
        O = vec4( .4-O.x * .3 + O.y);//0053
   #if (COLOR==1)     
        O *= O * vec4(2,1,0,0);
        O.x += .1;
        if(dt<.5 && dc1>0.){ // octagon foreground           
                O = mix(O, vec4(.9,.5,0,0), .5);
                O.xy += abs(dc1);
        }else if(dt>.5 && dc2>0.){ // square foreground
                O = mix(O, vec4(.9,.5,0,0), .5);
                O.xy += abs(dc2);
        }else{ // Freckled spots background
                //if(iMouse.y>iResolution.y*.51)
                O += .3 * exp(-40.*length(u-round(u*8.)/8.));
                ///O.y = .6; O.x -=;
                O.x += abs(dc1*dc1)+.05;
        }
        //O.x += .2;
   #else
        //if(dc1>0. || dc2>0.)
        //O = mix(O, vec4(.7), .5); // 1348
        //O.x*=2.;O.z*=0.;
        //O *= O * vec4(2,1,0,0);
        //O.x += .2;
        if(dt<.5 && dc1>0.){ // octagon foreground           
                O = mix(O, vec4(.8), .5);
                //O += 2.*abs(dc1);
        }else if(dt>.5 && dc2>0.){ // square foreground
                O = mix(O, vec4(.8), .5);
                //O += 2.*abs(dc2);
        }else{ // Freckled spots background
                if(iMouse.y>iResolution.y*.51)O += .3 * exp(-40.*length(u-round(u*8.)/8.));
                //O.y = .6; O.x -= .2;
        }
        
   #endif
        // Freckled spots
        //if((iMouse.x<iResolution.x*.51)^^(mod(iTime+8., 10.)<5.) )O = .9-O;
        if((iMouse.x>iResolution.x*.51) )
        {
                fragColor = .9-O;
                //O = (O-.2)*3.+.2;  
        }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

